"""
HB_SolidBevel V1.0

Last Modified: Oct/11/2018
Works with CINEMA 4D R16-R20 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_SolidBevel
Description-US:Sold-Bevel selected Edges [SHIFT: Make Bevel-Deformer, CTRL: Use Angle Threshold (40 Degree)]

Video Tutorial:
https://youtu.be/rAHc5mstOCg?t=546


ChangeLog:

Oct/11/2018 V1.0
- Release Version

"""

import c4d
from c4d import utils, gui


class NumericInputDialog(c4d.gui.GeDialog):
    idMainGroup = 1000
    idEditLabel = 1001
    idEditNumber = 1002
    idLabelSite = 1003
    value = 1

    def __init__(self, isFloat=True, mini=0.0, maxi=100000.0, defaultValue=1.0, step=0.01):
        self._isFloat = bool(isFloat)
        self._min     = float(mini) if self._isFloat else int(mini)
        self._max     = float(maxi) if self._isFloat else int(maxi)
        self._step    = float(step) if self._isFloat else int(step)
        self._def     = float(defaultValue) if self._isFloat else int(defaultValue)

    # Create the Layout
    def CreateLayout(self):
        self.SetTitle("HB_SolidBevel")
        if self.GroupBegin(self.idMainGroup, c4d.BFH_SCALEFIT):
            self.AddStaticText(self.idEditLabel, c4d.BFH_LEFT, 0, 0, "Radius :")
            self.AddEditNumberArrows(self.idEditNumber, c4d.BFH_SCALEFIT, initw=50, inith=20)
        self.GroupEnd()

        self.AddSeparatorH(15)
        self.AddDlgGroup(c4d.DLG_OK | c4d.DLG_CANCEL)
        self.AddStaticText(self.idLabelSite, c4d.BFH_CENTER, 0, 0, "www.c4dstuff.com", 0)
        return True

    # Called after CreateLayout
    def InitValues(self):
        func = self.SetFloat if self._isFloat else self.SetInt32
        func(self.idEditNumber, self._def, min=self._min, max=self._max, step=self._step, min2=self._min, max2=self._max)
        return True

    # Exit when the user press Enter
    def Command(self, id, msg):
        if id == c4d.DLG_OK:
            self.Close()

        elif id == c4d.DLG_CANCEL:
            self.value = None
            self.Close()

        elif id == self.idEditNumber:
            self.SetValueFromInput()
        return True

    def SetValueFromInput(self):
        func = self.GetFloat if self._isFloat else self.GetInt32
        self.value = func(self.idEditNumber)

def CurrentStateToObject(obj):

    Pos=obj.GetMg()
    CSsettings = c4d.BaseContainer()
    NewObj=utils.SendModelingCommand(command = c4d.MCOMMAND_CURRENTSTATETOOBJECT,
                                    list = [obj],
                                    mode = c4d.MODELINGCOMMANDMODE_ALL,
                                    bc = CSsettings,
                                    doc = doc,
                                    )


    NewObj[0].InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, NewObj[0])

    if NewObj[0].GetType()==c4d.Onull:
        NewObjChild=NewObj[0].GetDown()

        #doc.AddUndo(c4d.UNDOTYPE_DELETE, NewObj[0])
        NewObj[0].Remove()

    else:
        NewObjChild=NewObj[0]


    NewObjChild.InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, NewObjChild)

    NewObjChild.SetMg(Pos)


    doc.AddUndo(c4d.UNDOTYPE_CHANGE_SMALL,NewObjChild)
    NewObjChild.SetBit(c4d.BIT_ACTIVE)

    doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
    obj.Remove()

    deletetags(NewObjChild)
    return NewObjChild



def MakeBevelDeformer(obj,BevelRadius):

    bevelobj=c4d.BaseObject(431000028)
    bevelobj[c4d.O_BEVEL_MODE_COMPONENT_TYPE]=1
    bevelobj[c4d.O_BEVEL_LIMIT]=True

    if CTRL:
        bevelobj[c4d.O_BEVEL_MODE_SELECTION_ANGLE_USE]=True
        bevelobj[c4d.O_BEVEL_MODE_SELECTION_ANGLE_VAL]=0.523599



    bevelobj[c4d.O_BEVEL_MASTER_MODE]=1
    bevelobj[c4d.O_BEVEL_RADIUS]=float(BevelRadius)
    bevelobj.InsertUnder(obj)

    return



def MakeSolidBevel(obj,BevelRadius):

    bevelobj=c4d.BaseObject(431000028)
    bevelobj[c4d.O_BEVEL_MODE_COMPONENT_TYPE]=1
    bevelobj[c4d.O_BEVEL_LIMIT]=True


    #bevelobj[c4d.O_BEVEL_MODE_SELECTION_ANGLE_USE]=True
    #bevelobj[c4d.O_BEVEL_MODE_SELECTION_ANGLE_VAL]=0.785398



    bevelobj[c4d.O_BEVEL_MASTER_MODE]=1
    bevelobj[c4d.O_BEVEL_RADIUS]=float(BevelRadius)
    bevelobj[c4d.O_BEVEL_LIMIT]=True
    bevelobj[c4d.O_BEVEL_MITERING]=0
    bevelobj.InsertUnder(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, bevelobj)


    #RESTRICT DEFORMER


    seltag = obj.MakeTag(c4d.Tedgeselection)
    seltag_bs = seltag.GetBaseSelect()
    obj.GetEdgeS().CopyTo(seltag_bs)

    seltag.SetName("tempsel")

    obj.InsertTag(seltag)
    doc.AddUndo(c4d.UNDOTYPE_NEW, seltag)

    bevelobj[c4d.O_BEVEL_RESTRICTION_START]="tempsel"


    return



def deletetags(obj): # Scan Tags on Object

    n       = 1

    tags    = obj.GetTags()

    for tag in tags:
        if not tag: continue
        tagtype = tag.GetType()


        if tag.GetName()=="tempsel":
            doc.AddUndo(c4d.UNDOTYPE_DELETE, tag)
            tag.Remove()
            c4d.EventAdd()




def RemoveChildren(objlist):

    for obj in objlist:
        doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
        obj.Remove()



    c4d.EventAdd()
    return

def InsertChildren(objlist,root):


    for obj in objlist:

        obj.InsertUnder(root)
        doc.AddUndo(c4d.UNDOTYPE_NEW, obj)


    c4d.EventAdd()
    return


def main():

    global SHIFT, CTRL, BevelRadius
    SHIFT=False
    CTRL=False



    bc = c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)

    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : SHIFT=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : CTRL=True


    if len(doc.GetSelection()) == 0:
        gui.MessageDialog("Select at least one Object!")
        return

    floatDlg = NumericInputDialog()
    floatDlg.Open(c4d.DLG_TYPE_MODAL)
    if (floatDlg.value is None): return
    BevelRadius = floatDlg.value



    """
    USE for Integer Input
    intDlg = NumericInputDialog(isFloat=False, mini=-10, maxi=100, defaultValue=20, step=2)
    intDlg.Open(c4d.DLG_TYPE_MODAL)
    print intDlg.value"""








    #BevelRadius = dialog.Radius


    activeobjects = doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_CHILDREN)



    doc.StartUndo()


    if SHIFT or CTRL:
        for obj in activeobjects:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
            MakeBevelDeformer(obj,BevelRadius)


        return


    if doc.GetMode()!=6:
        gui.MessageDialog("Works only in Edgemode")
        return

    for obj in activeobjects:

            MakeSolidBevel(obj,BevelRadius)
            CurrentStateToObject(obj)






    doc.EndUndo()







if __name__=='__main__':
    main()
    c4d.EventAdd()